/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashSet;
import java.util.Set;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CantTouchGreenChallenge
extends Challenge {
    private static final Set<class_2248> GREEN_BLOCKS = new HashSet<class_2248>();
    private static final Set<class_1792> GREEN_ITEMS = new HashSet<class_1792>();
    private static final Set<class_1299<?>> GREEN_MOBS = new HashSet();
    private static final double MOB_CHECK_RADIUS = 0.75;

    public CantTouchGreenChallenge() {
        super("cant_touch_green", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_green.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.cant_touch_green.description"), false, Challenge.MultiplayerStatus.EXPERIMENTAL);
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    public boolean isGreenBlock(class_2248 block) {
        return GREEN_BLOCKS.contains(block);
    }

    public boolean isGreenItem(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            return this.isGreenBlock(block);
        }
        return GREEN_ITEMS.contains(item);
    }

    public boolean isGreenMob(class_1297 entity) {
        if (entity.method_5864() == class_1299.field_6052 || entity.method_5864() == class_1299.field_6044) {
            return false;
        }
        return GREEN_MOBS.contains(entity.method_5864()) || entity instanceof class_1621 && ((class_1621)entity).method_7152() > 0;
    }

    public boolean isExplosionMode() {
        return ChallengeSettings.getBooleanOption(this.getId(), "explosion_mode", false);
    }

    public void setExplosionMode(boolean explosionMode) {
        ChallengeSettings.setBooleanOption(this.getId(), "explosion_mode", explosionMode);
    }

    private void killPlayer(class_1657 player, String deathType, String targetName) {
        class_1937 class_19372;
        if (this.isExplosionMode()) {
            this.createExplosion(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), 3.0f);
            player.method_7353((class_2561)class_2561.method_43471((String)"challenges6t4.explosion.green_touch"), true);
        } else if (player instanceof class_3222 && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            player.method_64397(serverWorld, serverWorld.method_48963().method_48831(), Float.MAX_VALUE);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.green_touch." + deathType), (Object[])new Object[]{targetName}), true);
        } else {
            player.method_6033(0.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)("challenges6t4.death.green_touch." + deathType), (Object[])new Object[]{targetName}), true);
        }
    }

    public void createExplosion(class_1937 world, double x, double y, double z, float power) {
        world.method_8537(null, x, y, z, power, true, class_1937.class_7867.field_40891);
    }

    public boolean shouldKillPlayer(class_1657 player) {
        if (!this.isEnabled()) {
            return false;
        }
        class_2338 pos = player.method_24515();
        for (int y = 0; y <= 1; ++y) {
            class_2338 checkPos = pos.method_10086(y);
            class_2248 block = player.method_37908().method_8320(checkPos).method_26204();
            if (!GREEN_BLOCKS.contains(block)) continue;
            this.killPlayer(player, "block", block.method_9518().getString());
            return true;
        }
        class_2338 standingPos = class_2338.method_49637((double)player.method_23317(), (double)(player.method_23318() - 0.1), (double)player.method_23321());
        class_2248 standingBlock = player.method_37908().method_8320(standingPos).method_26204();
        if (GREEN_BLOCKS.contains(standingBlock)) {
            this.killPlayer(player, "block", standingBlock.method_9518().getString());
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.isGreenItem(stack.method_7909())) continue;
            this.killPlayer(player, "item", stack.method_7964().getString());
            return true;
        }
        class_238 checkBox = player.method_5829().method_1014(0.75);
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, checkBox)) {
            if (!this.isGreenMob(entity)) continue;
            this.killPlayer(player, "mob", entity.method_5477().getString());
            return true;
        }
        return false;
    }

    public void onAttackGreenMob(class_1657 player, class_1297 target) {
        if (this.isEnabled() && this.isGreenMob(target)) {
            this.killPlayer(player, "mob_attack", target.method_5477().getString());
        }
    }

    @Override
    public String getShowcaseVideoUrl() {
        return "https://youtu.be/5LhgnqxUIMQ";
    }

    static {
        GREEN_BLOCKS.add(class_2246.field_10219);
        GREEN_BLOCKS.add(class_2246.field_10479);
        GREEN_BLOCKS.add(class_2246.field_10214);
        GREEN_BLOCKS.add(class_2246.field_10376);
        GREEN_BLOCKS.add(class_2246.field_10238);
        GREEN_BLOCKS.add(class_2246.field_10476);
        GREEN_BLOCKS.add(class_2246.field_9993);
        GREEN_BLOCKS.add(class_2246.field_10463);
        GREEN_BLOCKS.add(class_2246.field_10597);
        GREEN_BLOCKS.add(class_2246.field_28681);
        GREEN_BLOCKS.add(class_2246.field_28680);
        GREEN_BLOCKS.add(class_2246.field_9989);
        GREEN_BLOCKS.add(class_2246.field_10207);
        GREEN_BLOCKS.add(class_2246.field_9990);
        GREEN_BLOCKS.add(class_2246.field_10405);
        GREEN_BLOCKS.add(class_2246.field_10065);
        GREEN_BLOCKS.add(class_2246.field_10024);
        GREEN_BLOCKS.add(class_2246.field_10173);
        GREEN_BLOCKS.add(class_2246.field_10059);
        GREEN_BLOCKS.add(class_2246.field_10480);
        GREEN_BLOCKS.add(class_2246.field_10234);
        GREEN_BLOCKS.add(class_2246.field_10398);
        GREEN_BLOCKS.add(class_2246.field_10526);
        GREEN_BLOCKS.add(class_2246.field_10475);
        GREEN_BLOCKS.add(class_2246.field_10367);
        GREEN_BLOCKS.add(class_2246.field_10529);
        GREEN_BLOCKS.add(class_2246.field_10170);
        GREEN_BLOCKS.add(class_2246.field_10338);
        GREEN_BLOCKS.add(class_2246.field_10198);
        GREEN_BLOCKS.add(class_2246.field_10594);
        GREEN_BLOCKS.add(class_2246.field_10503);
        GREEN_BLOCKS.add(class_2246.field_9988);
        GREEN_BLOCKS.add(class_2246.field_10539);
        GREEN_BLOCKS.add(class_2246.field_10335);
        GREEN_BLOCKS.add(class_2246.field_10098);
        GREEN_BLOCKS.add(class_2246.field_10035);
        GREEN_BLOCKS.add(class_2246.field_28673);
        GREEN_BLOCKS.add(class_2246.field_28674);
        GREEN_BLOCKS.add(class_2246.field_10029);
        GREEN_BLOCKS.add(class_2246.field_56564);
        GREEN_BLOCKS.add(class_2246.field_10211);
        GREEN_BLOCKS.add(class_2246.field_10108);
        GREEN_BLOCKS.add(class_2246.field_46283);
        GREEN_BLOCKS.add(class_2246.field_46287);
        GREEN_BLOCKS.add(class_2246.field_46285);
        GREEN_BLOCKS.add(class_2246.field_10424);
        GREEN_BLOCKS.add(class_2246.field_10588);
        GREEN_BLOCKS.add(class_2246.field_10394);
        GREEN_BLOCKS.add(class_2246.field_10217);
        GREEN_BLOCKS.add(class_2246.field_10575);
        GREEN_BLOCKS.add(class_2246.field_10276);
        GREEN_BLOCKS.add(class_2246.field_10385);
        GREEN_BLOCKS.add(class_2246.field_10160);
        GREEN_BLOCKS.add(class_2246.field_37544);
        GREEN_BLOCKS.add(class_2246.field_10226);
        GREEN_BLOCKS.add(class_2246.field_10573);
        GREEN_BLOCKS.add(class_2246.field_41072);
        GREEN_BLOCKS.add(class_2246.field_10108);
        GREEN_BLOCKS.add(class_2246.field_10086);
        GREEN_BLOCKS.add(class_2246.field_9995);
        GREEN_BLOCKS.add(class_2246.field_10182);
        GREEN_BLOCKS.add(class_2246.field_10378);
        GREEN_BLOCKS.add(class_2246.field_10548);
        GREEN_BLOCKS.add(class_2246.field_10048);
        GREEN_BLOCKS.add(class_2246.field_10554);
        GREEN_BLOCKS.add(class_2246.field_10003);
        GREEN_BLOCKS.add(class_2246.field_10315);
        GREEN_BLOCKS.add(class_2246.field_10449);
        GREEN_BLOCKS.add(class_2246.field_10270);
        GREEN_BLOCKS.add(class_2246.field_10430);
        GREEN_BLOCKS.add(class_2246.field_10583);
        GREEN_BLOCKS.add(class_2246.field_16999);
        GREEN_BLOCKS.add(class_2246.field_42734);
        GREEN_BLOCKS.add(class_2246.field_10156);
        GREEN_BLOCKS.add(class_2246.field_10606);
        GREEN_BLOCKS.add(class_2246.field_43229);
        GREEN_BLOCKS.add(class_2246.field_55741);
        GREEN_BLOCKS.add(class_2246.field_28678);
        GREEN_BLOCKS.add(class_2246.field_28679);
        GREEN_BLOCKS.add(class_2246.field_10293);
        GREEN_BLOCKS.add(class_2246.field_10030);
        GREEN_BLOCKS.add(class_2246.field_10234);
        GREEN_BLOCKS.add(class_2246.field_10013);
        GREEN_BLOCKS.add(class_2246.field_29220);
        GREEN_BLOCKS.add(class_2246.field_10561);
        GREEN_BLOCKS.add(class_2246.field_16336);
        GREEN_BLOCKS.add(class_2246.field_27120);
        GREEN_BLOCKS.add(class_2246.field_29221);
        GREEN_BLOCKS.add(class_2246.field_10297);
        GREEN_BLOCKS.add(class_2246.field_10623);
        GREEN_BLOCKS.add(class_2246.field_10130);
        GREEN_BLOCKS.add(class_2246.field_10135);
        GREEN_BLOCKS.add(class_2246.field_10006);
        GREEN_BLOCKS.add(class_2246.field_10236);
        GREEN_BLOCKS.add(class_2246.field_10190);
        GREEN_BLOCKS.add(class_2246.field_10530);
        GREEN_BLOCKS.add(class_2246.field_10389);
        GREEN_BLOCKS.add(class_2246.field_10350);
        GREEN_BLOCKS.add(class_2246.field_10342);
        GREEN_BLOCKS.add(class_2246.field_27105);
        GREEN_BLOCKS.add(class_2246.field_27148);
        GREEN_BLOCKS.add(class_2246.field_10421);
        GREEN_BLOCKS.add(class_2246.field_10046);
        GREEN_BLOCKS.add(class_2246.field_10275);
        GREEN_BLOCKS.add(class_2246.field_10055);
        GREEN_BLOCKS.add(class_2246.field_10318);
        GREEN_BLOCKS.add(class_2246.field_10229);
        GREEN_BLOCKS.add(class_2246.field_10040);
        GREEN_BLOCKS.add(class_2246.field_10133);
        GREEN_BLOCKS.add(class_2246.field_10028);
        GREEN_BLOCKS.add(class_2246.field_10180);
        GREEN_BLOCKS.add(class_2246.field_10157);
        GREEN_BLOCKS.add(class_2246.field_10305);
        GREEN_BLOCKS.add(class_2246.field_10615);
        GREEN_BLOCKS.add(class_2246.field_37573);
        GREEN_BLOCKS.add(class_2246.field_10195);
        GREEN_BLOCKS.add(class_2246.field_10443);
        GREEN_BLOCKS.add(class_2246.field_28682);
        GREEN_BLOCKS.add(class_2246.field_28684);
        GREEN_BLOCKS.add(class_2246.field_33509);
        GREEN_BLOCKS.add(class_2246.field_27118);
        GREEN_BLOCKS.add(class_2246.field_47056);
        GREEN_BLOCKS.add(class_2246.field_47065);
        GREEN_BLOCKS.add(class_2246.field_27123);
        GREEN_BLOCKS.add(class_2246.field_27131);
        GREEN_BLOCKS.add(class_2246.field_27127);
        GREEN_BLOCKS.add(class_2246.field_47041);
        GREEN_BLOCKS.add(class_2246.field_47049);
        GREEN_BLOCKS.add(class_2246.field_47073);
        GREEN_BLOCKS.add(class_2246.field_27117);
        GREEN_BLOCKS.add(class_2246.field_47055);
        GREEN_BLOCKS.add(class_2246.field_47066);
        GREEN_BLOCKS.add(class_2246.field_27122);
        GREEN_BLOCKS.add(class_2246.field_27130);
        GREEN_BLOCKS.add(class_2246.field_27126);
        GREEN_BLOCKS.add(class_2246.field_47043);
        GREEN_BLOCKS.add(class_2246.field_47051);
        GREEN_BLOCKS.add(class_2246.field_47074);
        GREEN_BLOCKS.add(class_2246.field_27116);
        GREEN_BLOCKS.add(class_2246.field_47054);
        GREEN_BLOCKS.add(class_2246.field_47067);
        GREEN_BLOCKS.add(class_2246.field_27121);
        GREEN_BLOCKS.add(class_2246.field_27129);
        GREEN_BLOCKS.add(class_2246.field_27125);
        GREEN_BLOCKS.add(class_2246.field_47042);
        GREEN_BLOCKS.add(class_2246.field_47050);
        GREEN_BLOCKS.add(class_2246.field_47075);
        GREEN_BLOCKS.add(class_2246.field_27135);
        GREEN_BLOCKS.add(class_2246.field_47060);
        GREEN_BLOCKS.add(class_2246.field_47069);
        GREEN_BLOCKS.add(class_2246.field_27137);
        GREEN_BLOCKS.add(class_2246.field_27169);
        GREEN_BLOCKS.add(class_2246.field_27166);
        GREEN_BLOCKS.add(class_2246.field_47045);
        GREEN_BLOCKS.add(class_2246.field_47053);
        GREEN_BLOCKS.add(class_2246.field_47077);
        GREEN_BLOCKS.add(class_2246.field_27134);
        GREEN_BLOCKS.add(class_2246.field_47059);
        GREEN_BLOCKS.add(class_2246.field_47070);
        GREEN_BLOCKS.add(class_2246.field_27136);
        GREEN_BLOCKS.add(class_2246.field_27168);
        GREEN_BLOCKS.add(class_2246.field_27139);
        GREEN_BLOCKS.add(class_2246.field_47047);
        GREEN_BLOCKS.add(class_2246.field_47063);
        GREEN_BLOCKS.add(class_2246.field_47078);
        GREEN_BLOCKS.add(class_2246.field_33407);
        GREEN_BLOCKS.add(class_2246.field_47058);
        GREEN_BLOCKS.add(class_2246.field_47071);
        GREEN_BLOCKS.add(class_2246.field_33408);
        GREEN_BLOCKS.add(class_2246.field_33410);
        GREEN_BLOCKS.add(class_2246.field_33409);
        GREEN_BLOCKS.add(class_2246.field_47046);
        GREEN_BLOCKS.add(class_2246.field_47062);
        GREEN_BLOCKS.add(class_2246.field_47079);
        GREEN_BLOCKS.add(class_2246.field_22113);
        GREEN_BLOCKS.add(class_2246.field_22127);
        GREEN_BLOCKS.add(class_2246.field_22129);
        GREEN_BLOCKS.add(class_2246.field_22099);
        GREEN_BLOCKS.add(class_2246.field_22133);
        GREEN_BLOCKS.add(class_2246.field_22097);
        GREEN_BLOCKS.add(class_2246.field_22103);
        GREEN_BLOCKS.add(class_2246.field_22095);
        GREEN_BLOCKS.add(class_2246.field_22131);
        GREEN_BLOCKS.add(class_2246.field_22101);
        GREEN_BLOCKS.add(class_2246.field_22111);
        GREEN_BLOCKS.add(class_2246.field_22503);
        GREEN_BLOCKS.add(class_2246.field_22114);
        GREEN_BLOCKS.add(class_2246.field_22116);
        GREEN_BLOCKS.add(class_2246.field_22115);
        GREEN_BLOCKS.add(class_2246.field_22105);
        GREEN_BLOCKS.add(class_2246.field_22107);
        GREEN_BLOCKS.add(class_2246.field_22504);
        GREEN_BLOCKS.add(class_2246.field_22112);
        GREEN_ITEMS.add(class_1802.field_8687);
        GREEN_ITEMS.add(class_1802.field_8777);
        GREEN_ITEMS.add(class_1802.field_8681);
        GREEN_ITEMS.add(class_1802.field_8573);
        GREEN_ITEMS.add(class_1802.field_8618);
        GREEN_ITEMS.add(class_1802.field_43193);
        GREEN_ITEMS.add(class_1802.field_17532);
        GREEN_ITEMS.add(class_1802.field_8179);
        GREEN_ITEMS.add(class_1802.field_8184);
        GREEN_ITEMS.add(class_1802.field_8635);
        GREEN_ITEMS.add(class_1802.field_8497);
        GREEN_ITEMS.add(class_1802.field_8648);
        GREEN_ITEMS.add(class_1802.field_8287);
        GREEN_ITEMS.add(class_1802.field_8470);
        GREEN_ITEMS.add(class_1802.field_8408);
        GREEN_ITEMS.add(class_1802.field_8131);
        GREEN_ITEMS.add(class_1802.field_33401);
        GREEN_ITEMS.add(class_1802.field_8662);
        GREEN_ITEMS.add(class_1802.field_8434);
        GREEN_ITEMS.add(class_1802.field_16998);
        GREEN_ITEMS.add(class_1802.field_23254);
        GREEN_ITEMS.add(class_1802.field_8317);
        GREEN_ITEMS.add(class_1802.field_42711);
        GREEN_ITEMS.add(class_1802.field_8090);
        GREEN_ITEMS.add(class_1802.field_8161);
        GREEN_ITEMS.add(class_1802.field_59713);
        GREEN_ITEMS.add(class_1802.field_59721);
        GREEN_ITEMS.add(class_1802.field_8509);
        GREEN_ITEMS.add(class_1802.field_28659);
        GREEN_ITEMS.add(class_1802.field_28410);
        GREEN_ITEMS.add(class_1802.field_54307);
        GREEN_ITEMS.add(class_1802.field_54315);
        GREEN_ITEMS.add(class_1802.field_8075);
        GREEN_ITEMS.add(class_1802.field_51628);
        GREEN_ITEMS.add(class_1802.field_8502);
        GREEN_ITEMS.add(class_1802.field_35358);
        GREEN_ITEMS.add(class_1802.field_51630);
        GREEN_ITEMS.add(class_1802.field_50139);
        GREEN_ITEMS.add(class_1802.field_8635);
        GREEN_ITEMS.add(class_1802.field_8714);
        GREEN_ITEMS.add(class_1802.field_8766);
        GREEN_ITEMS.add(class_1802.field_8288);
        GREEN_ITEMS.add(class_1802.field_41950);
        GREEN_MOBS.add(class_1299.field_6046);
        GREEN_MOBS.add(class_1299.field_6069);
        GREEN_MOBS.add(class_1299.field_6051);
        GREEN_MOBS.add(class_1299.field_6113);
        GREEN_MOBS.add(class_1299.field_6081);
        GREEN_MOBS.add(class_1299.field_6050);
        GREEN_MOBS.add(class_1299.field_23696);
        GREEN_MOBS.add(class_1299.field_6123);
        GREEN_MOBS.add(class_1299.field_6078);
        GREEN_MOBS.add(class_1299.field_6054);
        GREEN_MOBS.add(class_1299.field_42622);
        GREEN_MOBS.add(class_1299.field_6062);
        GREEN_MOBS.add(class_1299.field_6073);
        GREEN_MOBS.add(class_1299.field_6118);
        GREEN_MOBS.add(class_1299.field_6048);
        GREEN_MOBS.add(class_1299.field_6090);
        GREEN_MOBS.add(class_1299.field_6065);
        GREEN_MOBS.add(class_1299.field_6105);
        GREEN_MOBS.add(class_1299.field_6134);
        GREEN_MOBS.add(class_1299.field_6084);
        GREEN_MOBS.add(class_1299.field_28402);
        GREEN_MOBS.add(class_1299.field_6077);
        GREEN_MOBS.add(class_1299.field_17713);
        GREEN_MOBS.add(class_1299.field_38095);
        GREEN_MOBS.add(class_1299.field_6145);
        GREEN_MOBS.add(class_1299.field_6147);
        GREEN_MOBS.add(class_1299.field_49148);
    }
}

